/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.MainFrame;
import com.gallery.GalleryRemote.model.Picture;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.util.GRI18n;
import com.gallery.GalleryRemote.util.ImageLoaderUtil;
import com.gallery.GalleryRemote.util.ImageUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PreviewFrame
extends JFrame
implements PreferenceNames,
ImageLoaderUtil.ImageLoaderUser {
    public static final String MODULE = "PreviewFrame";
    Rectangle currentRect = null;
    ImageLoaderUtil loader;

    public void initComponents() {
        this.setTitle(GRI18n.getString(MODULE, "title"));
        this.setIconImage(GalleryRemote._().getMainFrame().getIconImage());
        this.setBounds(GalleryRemote._().properties.getPreviewBounds());
        this.setContentPane(new ImageContentPane());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                PreviewFrame.this.loader.flushMemory();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                MainFrame mainFrame = (MainFrame)GalleryRemote._().getMainFrame();
                if (mainFrame.activating == PreviewFrame.this) {
                    mainFrame.activating = null;
                    return;
                }
                if (mainFrame.activating == null && mainFrame.isVisible()) {
                    mainFrame.activating = PreviewFrame.this;
                    mainFrame.toFront();
                    PreviewFrame.this.toFront();
                }
            }
        });
        CropGlassPane glass = new CropGlassPane();
        this.setGlassPane(glass);
        glass.setVisible(true);
        this.loader = new ImageLoaderUtil(GalleryRemote._().properties.getIntProperty("cacheSize", 10), this);
    }

    public void hide() {
        this.loader.flushMemory();
        super.hide();
        this.loader.preparePicture(null, false, false);
    }

    public void pictureReady() {
        this.repaint();
    }

    public boolean blockPictureReady(Image image, Picture picture) {
        return false;
    }

    public Dimension getImageSize() {
        return this.getSize();
    }

    public void nullRect() {
        this.currentRect = null;
    }

    public void pictureStartDownloading(Picture picture) {
    }

    public void pictureStartProcessing(Picture picture) {
    }

    public void pictureLoadError(Picture picture) {
    }

    class CropGlassPane
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        Color background = new Color(100, 100, 100, 150);
        boolean inDrag;
        Point2D start = null;
        Point2D end = null;
        Point2D moveCropStart = null;
        Rectangle oldRect = null;
        Rectangle cacheRect = null;
        boolean centerMode = false;
        Picture localCurrentPicture = null;
        int movingEdge = 0;
        public static final int TOLERANCE = 5;

        public CropGlassPane() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public void paint(Graphics g) {
            this.oldRect = null;
            if (this.localCurrentPicture != PreviewFrame.this.loader.pictureShowNow) {
                this.cacheRect = null;
                this.localCurrentPicture = PreviewFrame.this.loader.pictureShowNow;
            }
            if (PreviewFrame.this.loader.pictureShowNow == null || PreviewFrame.this.loader.imageShowNow == null || PreviewFrame.this.loader.pictureShowNow.isOnline()) {
                this.cacheRect = null;
                return;
            }
            if (PreviewFrame.this.currentRect != null && this.start != null && this.end != null) {
                Rectangle ct = PreviewFrame.this.loader.pictureShowNow.getCropTo();
                if (ct != null) {
                    AffineTransform t = ImageUtils.createTransform(this.getBounds(), PreviewFrame.this.currentRect, PreviewFrame.this.loader.pictureShowNow.getDimension(), PreviewFrame.this.loader.pictureShowNow.getAngle(), PreviewFrame.this.loader.pictureShowNow.isFlipped());
                    try {
                        this.cacheRect = this.getRect(t.inverseTransform(ct.getLocation(), null), t.inverseTransform(new Point(ct.x + ct.width, ct.y + ct.height), null));
                        g.setColor(this.background);
                        g.setClip(PreviewFrame.this.currentRect);
                        g.fillRect(0, 0, this.cacheRect.x, this.getHeight());
                        g.fillRect(this.cacheRect.x, 0, this.getWidth() - this.cacheRect.x, this.cacheRect.y);
                        g.fillRect(this.cacheRect.x, this.cacheRect.y + this.cacheRect.height, this.getWidth() - this.cacheRect.x, this.getHeight() - this.cacheRect.y - this.cacheRect.height);
                        g.fillRect(this.cacheRect.x + this.cacheRect.width, this.cacheRect.y, this.getWidth() - this.cacheRect.x - this.cacheRect.width, this.cacheRect.height);
                        g.setColor(Color.black);
                        g.drawRect(this.cacheRect.x, this.cacheRect.y, this.cacheRect.width, this.cacheRect.height);
                        if (GalleryRemote._().properties.getBooleanProperty("previewDrawThirds", false)) {
                            g.setColor(this.background);
                            g.drawLine(this.cacheRect.x + this.cacheRect.width / 3, this.cacheRect.y, this.cacheRect.x + this.cacheRect.width / 3, this.cacheRect.y + this.cacheRect.height);
                            g.drawLine(this.cacheRect.x + this.cacheRect.width * 2 / 3, this.cacheRect.y, this.cacheRect.x + this.cacheRect.width * 2 / 3, this.cacheRect.y + this.cacheRect.height);
                            g.drawLine(this.cacheRect.x, this.cacheRect.y + this.cacheRect.height / 3, this.cacheRect.x + this.cacheRect.width, this.cacheRect.y + this.cacheRect.height / 3);
                            g.drawLine(this.cacheRect.x, this.cacheRect.y + this.cacheRect.height * 2 / 3, this.cacheRect.x + this.cacheRect.width, this.cacheRect.y + this.cacheRect.height * 2 / 3);
                        }
                        g.setClip(null);
                    }
                    catch (NoninvertibleTransformException e) {
                        Log.logException(1, PreviewFrame.MODULE, e);
                    }
                } else if (this.movingEdge == 0) {
                    this.cacheRect = null;
                }
            } else {
                this.cacheRect = null;
            }
            this.paintInfo(g);
        }

        public void paintInfo(Graphics g) {
            String message = null;
            Rectangle cropTo = PreviewFrame.this.loader.pictureShowNow.getCropTo();
            message = !this.inDrag ? (cropTo == null ? GRI18n.getString(PreviewFrame.MODULE, "noCrop") : GRI18n.getString(PreviewFrame.MODULE, "crop")) : (this.movingEdge == 0 ? GRI18n.getString(PreviewFrame.MODULE, "inCrop") : GRI18n.getString(PreviewFrame.MODULE, "inModify"));
            g.setFont(g.getFont());
            ImageLoaderUtil.paintOutline(g, message, 5, this.getBounds().height - 5, 1);
        }

        public void updateRect() {
            Graphics g = this.getGraphics();
            if (this.oldRect != null) {
                g.setXORMode(Color.cyan);
                g.drawRect(this.oldRect.x, this.oldRect.y, this.oldRect.width, this.oldRect.height);
                if (GalleryRemote._().properties.getBooleanProperty("previewDrawThirds", false)) {
                    g.drawLine(this.oldRect.x + this.oldRect.width / 3, this.oldRect.y, this.oldRect.x + this.oldRect.width / 3, this.oldRect.y + this.oldRect.height);
                    g.drawLine(this.oldRect.x + this.oldRect.width * 2 / 3, this.oldRect.y, this.oldRect.x + this.oldRect.width * 2 / 3, this.oldRect.y + this.oldRect.height);
                    g.drawLine(this.oldRect.x, this.oldRect.y + this.oldRect.height / 3, this.oldRect.x + this.oldRect.width, this.oldRect.y + this.oldRect.height / 3);
                    g.drawLine(this.oldRect.x, this.oldRect.y + this.oldRect.height * 2 / 3, this.oldRect.x + this.oldRect.width, this.oldRect.y + this.oldRect.height * 2 / 3);
                }
            }
            if (this.inDrag) {
                g.setXORMode(Color.cyan);
                this.oldRect = this.getRect(this.start, this.end);
                g.drawRect(this.oldRect.x, this.oldRect.y, this.oldRect.width, this.oldRect.height);
                if (GalleryRemote._().properties.getBooleanProperty("previewDrawThirds", false)) {
                    g.drawLine(this.oldRect.x + this.oldRect.width / 3, this.oldRect.y, this.oldRect.x + this.oldRect.width / 3, this.oldRect.y + this.oldRect.height);
                    g.drawLine(this.oldRect.x + this.oldRect.width * 2 / 3, this.oldRect.y, this.oldRect.x + this.oldRect.width * 2 / 3, this.oldRect.y + this.oldRect.height);
                    g.drawLine(this.oldRect.x, this.oldRect.y + this.oldRect.height / 3, this.oldRect.x + this.oldRect.width, this.oldRect.y + this.oldRect.height / 3);
                    g.drawLine(this.oldRect.x, this.oldRect.y + this.oldRect.height * 2 / 3, this.oldRect.x + this.oldRect.width, this.oldRect.y + this.oldRect.height * 2 / 3);
                }
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (PreviewFrame.this.loader.pictureShowNow == null) {
                return;
            }
            PreviewFrame.this.loader.pictureShowNow.setCropTo(null);
            this.cacheRect = null;
            this.repaint();
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (PreviewFrame.this.loader.pictureShowNow == null || PreviewFrame.this.currentRect == null || PreviewFrame.this.loader.pictureShowNow.isOnline()) {
                return;
            }
            if (this.cacheRect == null) {
                this.movingEdge = 0;
            }
            this.inDrag = true;
            switch (this.movingEdge) {
                case 1: {
                    this.start = this.validate(new Point(this.cacheRect.x + this.cacheRect.width, this.cacheRect.y + this.cacheRect.height));
                    break;
                }
                case 3: {
                    this.start = this.validate(new Point(this.cacheRect.x, this.cacheRect.y));
                    break;
                }
                case 2: {
                    this.start = this.validate(new Point(this.cacheRect.x + this.cacheRect.width, this.cacheRect.y + this.cacheRect.height));
                    break;
                }
                case 4: {
                    this.start = this.validate(new Point(this.cacheRect.x, this.cacheRect.y));
                    break;
                }
                case 5: {
                    this.moveCropStart = this.validate(e.getPoint());
                    break;
                }
                default: {
                    this.start = this.validate(e.getPoint());
                }
            }
            PreviewFrame.this.loader.pictureShowNow.setCropTo(null);
            this.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            this.inDrag = false;
            this.centerMode = false;
            if (PreviewFrame.this.loader.pictureShowNow == null || this.oldRect == null || PreviewFrame.this.loader.pictureShowNow.isOnline()) {
                return;
            }
            AffineTransform t = ImageUtils.createTransform(this.getBounds(), PreviewFrame.this.currentRect, PreviewFrame.this.loader.pictureShowNow.getDimension(), PreviewFrame.this.loader.pictureShowNow.getAngle(), PreviewFrame.this.loader.pictureShowNow.isFlipped());
            Rectangle tmpRect = new Rectangle();
            tmpRect.setFrameFromDiagonal(t.transform(this.oldRect.getLocation(), null), t.transform(new Point(this.oldRect.x + this.oldRect.width, this.oldRect.y + this.oldRect.height), null));
            PreviewFrame.this.loader.pictureShowNow.setCropTo(tmpRect);
            this.setCursor(Cursor.getDefaultCursor());
            this.repaint();
        }

        public void mouseDragged(MouseEvent e) {
            Point2D p;
            if (PreviewFrame.this.currentRect == null) {
                return;
            }
            if (this.cacheRect == null) {
                this.movingEdge = 0;
            }
            int modifiers = e.getModifiersEx();
            switch (this.movingEdge) {
                case 1: {
                    p = this.validate(new Point(this.cacheRect.x, (int)e.getPoint().getY()));
                    modifiers = 0;
                    break;
                }
                case 3: {
                    p = this.validate(new Point(this.cacheRect.x + this.cacheRect.width, (int)e.getPoint().getY()));
                    modifiers = 0;
                    break;
                }
                case 2: {
                    p = this.validate(new Point((int)e.getPoint().getX(), this.cacheRect.y));
                    modifiers = 0;
                    break;
                }
                case 4: {
                    p = this.validate(new Point((int)e.getPoint().getX(), this.cacheRect.y + this.cacheRect.height));
                    modifiers = 0;
                    break;
                }
                case 5: {
                    double dx = e.getPoint().getX() - this.moveCropStart.getX();
                    double dy = e.getPoint().getY() - this.moveCropStart.getY();
                    this.start = this.validate(new Point((int)((double)this.cacheRect.x + dx), (int)((double)this.cacheRect.y + dy)));
                    p = new Point((int)((double)(this.cacheRect.x + this.cacheRect.width) + dx), (int)((double)(this.cacheRect.y + this.cacheRect.height) + dy));
                    modifiers = 0;
                    break;
                }
                default: {
                    p = this.validate(e.getPoint());
                }
            }
            double px = p.getX();
            double py = p.getY();
            if ((modifiers & 0x40) == 64) {
                double dx = px - this.start.getX();
                double dy = py - this.start.getY();
                if (Math.abs(dx) < Math.abs(dy)) {
                    py = this.start.getY() + (dy * dx > 0.0 ? dx : -dx);
                } else {
                    px = this.start.getX() + (dx * dy > 0.0 ? dy : -dy);
                }
                p.setLocation(px, py);
            } else if ((modifiers & 0x80) == 128) {
                int dx = (int)(px - this.start.getX());
                int dy = (int)(py - this.start.getY());
                int sameOrientation = (Math.abs(dx) - Math.abs(dy)) * (PreviewFrame.this.currentRect.width - PreviewFrame.this.currentRect.height);
                Dimension target = sameOrientation > 0 ? new Dimension(dx, dy) : new Dimension(dy, dx);
                Dimension d = ImageUtils.getSizeKeepRatio(PreviewFrame.this.currentRect.getSize(), target, false);
                if (sameOrientation > 0) {
                    p.setLocation(this.start.getX() + (double)d.width, this.start.getY() + (double)d.height);
                } else {
                    p.setLocation(this.start.getX() + (double)d.height, this.start.getY() + (double)d.width);
                }
            }
            this.centerMode = (modifiers & 0x200) == 512;
            this.end = this.validate(p);
            this.updateRect();
        }

        public void mouseMoved(MouseEvent e) {
            if (PreviewFrame.this.loader.pictureShowNow == null || PreviewFrame.this.loader.imageShowNow == null || PreviewFrame.this.loader.pictureShowNow.isOnline() || this.cacheRect == null) {
                this.movingEdge = 0;
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            double px = e.getPoint().getX();
            double py = e.getPoint().getY();
            boolean canMove = false;
            if (px >= (double)(this.cacheRect.x + 5) && px <= (double)(this.cacheRect.x + this.cacheRect.width - 5)) {
                if (Math.abs(py - (double)this.cacheRect.y) < 5.0) {
                    this.movingEdge = 1;
                    this.setCursor(Cursor.getPredefinedCursor(8));
                    canMove = true;
                } else if (Math.abs(py - (double)this.cacheRect.y - (double)this.cacheRect.height) < 5.0) {
                    this.movingEdge = 3;
                    this.setCursor(Cursor.getPredefinedCursor(9));
                    canMove = true;
                }
            }
            if (py >= (double)(this.cacheRect.y + 5) && py <= (double)(this.cacheRect.y + this.cacheRect.height - 5)) {
                if (Math.abs(px - (double)this.cacheRect.x) < 5.0) {
                    this.movingEdge = 2;
                    this.setCursor(Cursor.getPredefinedCursor(10));
                    canMove = true;
                } else if (Math.abs(px - (double)this.cacheRect.x - (double)this.cacheRect.width) < 5.0) {
                    this.movingEdge = 4;
                    this.setCursor(Cursor.getPredefinedCursor(11));
                    canMove = true;
                }
            }
            if (px >= (double)(this.cacheRect.x + 5) && px <= (double)(this.cacheRect.x + this.cacheRect.width - 5) && py >= (double)(this.cacheRect.y + 5) && py <= (double)(this.cacheRect.y + this.cacheRect.height - 5)) {
                this.movingEdge = 5;
                this.setCursor(Cursor.getPredefinedCursor(13));
                canMove = true;
            }
            if (!canMove) {
                this.movingEdge = 0;
                this.setCursor(Cursor.getDefaultCursor());
            }
        }

        public Rectangle getRect(Point2D p1, Point2D p2) {
            Rectangle r = new Rectangle();
            if (this.centerMode) {
                r.setFrameFromCenter(p1, p2);
                p1 = new Point2D.Double(r.getMinX(), r.getMinY());
                p2 = new Point2D.Double(r.getMaxX(), r.getMaxY());
            }
            r.setFrameFromDiagonal(this.validate(p1), this.validate(p2));
            return r;
        }

        public Point2D validate(Point2D p) {
            double px = p.getX();
            double py = p.getY();
            if (px < (double)PreviewFrame.this.currentRect.x) {
                px = PreviewFrame.this.currentRect.x;
            }
            if (py < (double)PreviewFrame.this.currentRect.y) {
                py = PreviewFrame.this.currentRect.y;
            }
            if (px > (double)(PreviewFrame.this.currentRect.x + PreviewFrame.this.currentRect.width - 1)) {
                px = PreviewFrame.this.currentRect.x + PreviewFrame.this.currentRect.width - 1;
            }
            if (py > (double)(PreviewFrame.this.currentRect.y + PreviewFrame.this.currentRect.height - 1)) {
                py = PreviewFrame.this.currentRect.y + PreviewFrame.this.currentRect.height - 1;
            }
            return new Point2D.Double(px, py);
        }
    }

    class ImageContentPane
    extends JPanel {
        ImageContentPane() {
        }

        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Color c = GalleryRemote._().properties.getColorProperty("slideshowColor");
            if (c != null) {
                g.setColor(c);
            } else {
                g.setColor(this.getBackground());
            }
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            if (PreviewFrame.this.loader.imageShowNow != null && PreviewFrame.this.loader.pictureShowWant != null) {
                Log.log(3, PreviewFrame.MODULE, "New image: " + PreviewFrame.this.loader.imageShowNow);
                Image tmpImage = ImageUtils.rotateImage(PreviewFrame.this.loader.imageShowNow, PreviewFrame.this.loader.pictureShowWant.getAngle(), PreviewFrame.this.loader.pictureShowWant.isFlipped(), this);
                PreviewFrame.this.currentRect = new Rectangle(this.getLocation().x + (this.getWidth() - tmpImage.getWidth(this)) / 2, this.getLocation().y + (this.getHeight() - tmpImage.getHeight(this)) / 2, tmpImage.getWidth(this), tmpImage.getHeight(this));
                g2.drawImage(tmpImage, PreviewFrame.this.currentRect.x, PreviewFrame.this.currentRect.y, PreviewFrame.this.getContentPane());
            }
        }
    }
}

